

<?php $__env->startSection('page', $page); ?>
<?php $__env->startSection('title', getSetting('APPLICATION_NAME') . ' | ' . $page); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <?php echo $__env->make('include.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="row">
                <div class="col-md-6">
                    <a href="<?php echo e(route('createUser')); ?>">
                        <button class="btn btn-primary btn-sm" id="createUser" title="<?php echo e(__('Create User')); ?>">
                            <?php echo e(__('Create')); ?>

                        </button>
                    </a>
                    <a href="<?php echo e(route('user.export', request()->query())); ?>">
                        <button class="btn btn-primary btn-sm">
                            <i class="fas fa-cloud-download-alt"></i> <?php echo e('Export'); ?>

                        </button>
                    </a>
                </div>
                <div class="col-md-12 search-section">
                    <a class="search-penal collapsed" data-toggle="collapse" href="#collapseExample" role="button"
                        aria-expanded="false" aria-controls="collapseExample">
                        <?php echo e(__('Search')); ?>

                        <i class="fas fa-angle-right ml-auto"></i>
                    </a>
                </div>
            </div>
            <?php echo $__env->make('admin.user.search', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th><?php echo e(__('ID')); ?></th>
                        <th><?php echo e(__('Username')); ?></th>
                        <th><?php echo e(__('Email')); ?></th>
                        <th><?php echo e(__('Plan')); ?></th>
                        <th><?php echo e(__('Source')); ?></th>
                        <th><?php echo e(__('Created Date')); ?></th>
                        <th><?php echo e(__('Status')); ?></th>
                        <th><?php echo e(__('Action')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($value->id); ?></td>
                            <td><?php echo e($value->username); ?></td>
                            <td><?php echo e($value->email); ?></td>
                            <!-- <td><?php echo e($value->name); ?></td> -->
                            <td>
                                <select class="form-control assignPlan">
                                    <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($val); ?>|<?php echo e($value->id); ?>"
                                            <?php echo e($val == $value->plan_id ? 'selected' : ''); ?>><?php echo e($key); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </td>
                            <?php if($value->facebook_id): ?>
                                <td>Facebook</td>
                            <?php elseif($value->twitter_id): ?>
                                <td>Twitter</td>
                            <?php elseif($value->google_id): ?>
                                <td>Google</td>
                            <?php elseif($value->linkedin_id): ?>
                                <td>LinkedIn</td>
                            <?php else: ?>
                                <td><?php echo e(__('Register')); ?></td>
                            <?php endif; ?>

                            <td><?php echo e($value->created_at); ?></td>
                            <td>
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input user-status"
                                        data-id="<?php echo e($value->id); ?>" id="customSwitch<?php echo e($value->id); ?>"
                                        <?php echo e($value->status == 'active' ? 'checked' : ''); ?>>
                                    <label class="custom-control-label" for="customSwitch<?php echo e($value->id); ?>"></label>
                                </div>
                            </td>
                            <td>
                                <button class="btn btn-danger btn-sm delete-user" data-id="<?php echo e($value->id); ?>"
                                    title="<?php echo e(__('Delete')); ?>">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot>
                    <tr>
                        <th><?php echo e(__('ID')); ?></th>
                        <th><?php echo e(__('Username')); ?></th>
                        <th><?php echo e(__('Email')); ?></th>
                        <th><?php echo e(__('Plan')); ?></th>
                        <th><?php echo e(__('Source')); ?></th>
                        <th><?php echo e(__('Created Date')); ?></th>
                        <th><?php echo e(__('Status')); ?></th>
                        <th><?php echo e(__('Action')); ?></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
    <div class="card-footer">
        <div class="float-right">
            <?php echo e($users->links()); ?>

        </div>
    </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/originsuiteai/webinar.originsuiteai.com/resources/views/admin/user/index.blade.php ENDPATH**/ ?>