

<?php $__env->startSection('title', getSetting('APPLICATION_NAME') . ' | ' . $page . ' | ' . $meeting->title); ?>

<?php $__env->startSection('style'); ?>
    <link href="<?php echo e(asset('css/meeting.css?version=') . getVersion()); ?>" rel="stylesheet">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container meeting-details">
        <canvas id="audioOnly" hidden></canvas>
        <div class="row h-100 justify-content-center align-items-center">
            <div class="col-lg-7 video-detail">
                <div class="video-Section">
                    <video id="previewVideo" class="cam" autoplay playsinline muted></video>
                    <div class="cameraText"><?php echo e(__('Camera is off')); ?></div>
                    <div class="video-controls">
                        <ul>
                            <li id="toggleMicPreview" class="disabled" data-toggle="tooltip" data-placement="top"
                                title="<?php echo e(__('Mute/Unmute Mic')); ?>">
                                <em class="fa fa-microphone-slash"></em>
                            </li>
                            <li id="toggleCameraPreview" class="disabled" data-toggle="tooltip" data-placement="top"
                                title="<?php echo e(__('On/Off Camera')); ?>">
                                <em class="fa fa-video-slash"></em>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="text-show" style="color: red;"></div>
            </div>
            <div class="col-lg-5 mb-3 mt-3">
                <div class="card mb-0">
                    <div class="card-header">
                        <h5><?php echo e($meeting->title); ?></h5>
                    </div>
                    <div class="card-body">
                        <?php if($meeting->timeLimit == -1): ?>
                            <div class="ribbon-wrapper ribbon-xl">
                                <div class="ribbon bg-primary" title="<?php echo e(__('Time Limit')); ?>">
                                    <?php echo e(__('Unlimited') . ' ' . __('Minutes')); ?>

                                </div>
                            </div>
                        <?php else: ?>
                            <div class="ribbon-wrapper ribbon-lg">
                                <div class="ribbon bg-primary" title="<?php echo e(__('Time Limit')); ?>">
                                    <?php echo e($meeting->timeLimit . ' ' . __('Minutes')); ?>

                                </div>
                            </div>
                        <?php endif; ?>
                        <form id="passwordCheck">
                            <div class="form-group">
                                <h6><i class="fa fa-id-badge mr-1"></i> <?php echo e($meeting->meeting_id); ?></h6>
                            </div>
                            <?php if(getSetting('AUTH_MODE') == 'enabled'): ?>
                                <div class="form-group">
                                    <h6><i class="fa fa-calendar mr-1"></i>
                                        <?php echo e($meeting->date ? formatDate($meeting->date) : '-'); ?></h6>
                                </div>
                                <div class="form-group">
                                    <h6><i class="fa fa-clock mr-1"></i>
                                        <?php echo e($meeting->time ? formatTime($meeting->time) : '-'); ?></h6>
                                </div>
                                <div class="form-group">
                                    <h6><i class="fa fa-globe mr-1"></i>
                                        <?php echo e($meeting->timezone ? $meeting->timezone : '-'); ?></h6>
                                </div>
                            <?php endif; ?>
                            <div class="form-group">
                                <p class="mb-1 meetDesc"><?php echo e($meeting->description ? $meeting->description : '-'); ?></p>
                            </div>

                            <div class="form-group row" <?php if(Auth::check()): ?> hidden <?php endif; ?>>
                                <div class="col-12 col-md-10 offset-md-1">
                                    <input type="text" id="username" class="form-control"
                                        value="<?php echo e($meeting->username); ?>" placeholder="<?php echo e(__('Enter your name')); ?>"
                                        maxlength="25" />
                                </div>
                            </div>

                            <?php if($meeting->password): ?>
                                <div class="form-group row">
                                    <div class="col-12 col-md-10 offset-md-1">
                                        <input id="password" type="text" class="form-control" name="password"
                                            placeholder="<?php echo e(__('Enter meeting password')); ?>" maxlength="8" required />
                                        <input type="hidden" name="id" value="<?php echo e($meeting->id); ?>" />
                                    </div>
                                </div>
                            <?php endif; ?>

                            <div class="form-group row mb-0">
                                <div class="col-md-12 text-center">
                                    <button class="btn btn-primary" id="joinMeeting" data-toggle="tooltip"
                                        data-placement="top" title="<?php echo e(__('Join Meeting')); ?>" type="submit"
                                        disabled><?php echo e(__('Join')); ?></button>
                                    <button class="btn btn-info" type="button" data-toggle="modal"
                                        data-target="#shortcutInfo" data-toggle="tooltip" data-placement="top"
                                        title="<?php echo e(__('Shortcut Keys information')); ?>"><i class="fa fa-info"></i></button>
                                    <button class="btn btn-warning add" type="button" data-toggle="tooltip"
                                        data-placement="top" title="<?php echo e(__('Share Link')); ?>"><i
                                            class="fa fa-share-alt"></i></button>
                                </div>
                                <div id="error">
                                    <p><?php echo e(__('Could not connect to the server, please try refreshing the page')); ?></p>

                                    <?php if($meeting->isAdmin): ?>
                                        <a href="/signaling" target="_blank"><span class="badge badge-warning p-2"><i
                                                    class="fa fa-exclamation-triangle"></i>
                                                <?php echo e(__('Troubleshooting steps (Visible to the admin only)')); ?></span></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid meeting-section">
        <div class="row">
            <div id="videos">
                <div id="selfContainer" class="videoContainer">
                    <img src="<?php echo e(asset('storage/images/SECONDARY_LOGO.png')); ?>" class="meeting-logo"
                        alt="<?php echo e(getSetting('APPLICATION_NAME')); ?>" />
                    <audio id="localAudio" autoplay muted></audio>
                    <video id="localVideo" class="cam" autoplay playsinline></video>
                    <span class="local-user-name"><?php echo e(__('You')); ?>

                        <i class='fas fa-crown moderator-icon' title='<?php echo e(__('Moderator')); ?>' <?php if(!$meeting->isModerator): ?> style="display: none" <?php endif; ?>></i>
                    </span>
                    <?php if(getAuthUserInfo('avatar')): ?>
                        <img class="user-initial" src="<?php echo e(asset('storage/avatars/' . getAuthUserInfo('avatar'))); ?>" />
                    <?php else: ?>
                        <p class="user-initial"></p>
                    <?php endif; ?>
                </div>
                <div id="screenContainer" class="videoContainer OT_big">
                    <audio id="localScreenAudio" autoplay muted></audio>
                    <video id="localScreenVideo" autoplay playsinline></video>
                    <span class="local-user-name"><?php echo e(__('Your screen')); ?></span>
                </div>
            </div>
            <div id="whiteboardSection"></div>
        </div>

        <div class="meeting-info text-center">
            <span id="meetingIdInfo" class="text-center"></span>
            <br>
            <span id="timer" class="text-center"></span>
        </div>

        <div class="chat-panel">
            <div class="chat-box">
                <div class="chat-header">
                    <?php echo e(__('Group Chat')); ?>

                    <i class="fas fa-times close-panel"></i>
                </div>
                <div class="chat-body">
                    <div class="empty-chat-body">
                        <i class="fa fa-comments chat-icon"></i>
                    </div>
                </div>
                <div class="chat-footer">
                    <form id="chatForm">
                        <div class="input-group">
                            <input type="text" id="messageInput" class="form-control note-input"
                                placeholder="<?php echo e(__('Type a message')); ?>" autocomplete="off" maxlength="250" />
                            <div class="input-group-append">
                                <button id="sendMessage" class="btn btn-outline-secondary" type="submit"
                                    title="<?php echo e(__('Send')); ?>">
                                    <i class="fa fa-paper-plane"></i>
                                </button>
                                <button id="selectFile" class="btn btn-outline-secondary"
                                    title="<?php echo e(__('Attach File')); ?>" type="button">
                                    <i class="fas fa-paperclip"></i>
                                </button>
                                <button id="emojiPicker" class="btn btn-outline-secondary" title="<?php echo e(__('Emoji')); ?>"
                                    type="button">
                                    <i class="fa fa-smile"></i>
                                </button>
                            </div>
                        </div>
                    </form>
                    <input type="file" name="file" id="file" data-max="50" hidden />
                </div>
            </div>
        </div>

        <div class="chatgpt-panel">
            <div class="chatgpt-box">
                <div class="chatgpt-header">
                    <img src="/images/chatgpt-logo.png" width="30" alt="<?php echo e(__('ChatGPT')); ?>" />
                    <?php echo e(__('ChatGPT')); ?>

                    <i class="fas fa-times close-chatgpt-panel"></i>
                </div>
                <div class="chatgpt-body">
                    <div class="empty-chatgpt-body">
                        <i class="fa fa-magic chat-icon"></i>
                    </div>
                </div>
                <div class="chatgpt-footer">
                    <form id="chatGPTchatForm">
                        <div class="input-group">
                            <input type="text" id="chatGPTmessageInput" class="form-control note-input"
                                placeholder="<?php echo e(__('Message ChatGPT')); ?>" autocomplete="off" maxlength="250" />
                            <div class="input-group-append">
                                <button id="chatGPTSendMessage" class="btn btn-outline-secondary" type="submit"
                                    title="<?php echo e(__('Send')); ?>">
                                    <i class="far fa-paper-plane"></i>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="meeting-options">
            <button class="btn meeting-option" title="<?php echo e(__('Group Chat')); ?>" id="openChat">
                <i class="fa fa-comments"></i>
            </button>
            <button class="btn meeting-option" title="<?php echo e(__('ChatGPT')); ?>" id="openChatGPT">
                <i class="fa fa-magic"></i>
            </button>
            <button class="btn meeting-option" title="<?php echo e(__('Participants')); ?>" data-toggle="modal"
                data-target="#participantList" id="showParticipantList">
                <i class="fas fa-users"></i>
            </button>
            <button class="btn meeting-option" title="<?php echo e(__('Whiteboard')); ?>" id="whiteboard">
                <i class="fa fa-chalkboard"></i>
            </button>
            <button class="btn meeting-option" title="<?php echo e(__('Mute/Unmute Mic')); ?>" id="toggleMic">
                <i class="fa fa-microphone"></i>
            </button>
            <button class="btn btn-danger" title="<?php echo e(__('Leave Meeting')); ?>" id="leave">
                <i class="fas fa-phone"></i>
            </button>
            <button class="btn meeting-option" title="<?php echo e(__('On/Off Camera')); ?>" id="toggleVideo">
                <i class="fa fa-video"></i>
            </button>
            <button class="btn meeting-option" title="<?php echo e(__('Start/Stop ScreenShare')); ?>" id="screenShare">
                <i class="fa fa-desktop"></i>
            </button>
            <button class="btn meeting-option" title="<?php echo e(__('Raise Hand')); ?>" id="raiseHand">
                <i class="fa fa-hand-paper"></i>
            </button>
            <button class="btn meeting-option" title="<?php echo e(__('Start/Stop Recording')); ?>" id="recording">
                <i class="fa fa-record-vinyl"></i>
            </button>
            <button class="btn meeting-option openSettings" title="<?php echo e(__('Open Settings')); ?>">
                <i class="fa fa-cog"></i>
            </button>
            <button class="btn meeting-option" title="<?php echo e(__('Mute/Unmute All')); ?>" id="muteAll">
                <i class="fas fa-users"></i>
            </button>
        </div>
    </div>

    <div class="modal fade" id="previewModal" tabindex="-1" role="dialog" aria-labelledby="previewModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="previewModalLabel"><?php echo e(__('File Preview')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <img id="previewImage" src="" />
                    <p id="previewFilename"></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                    <button type="button" id="sendFile" class="btn btn-primary"><?php echo e(__('Send')); ?></button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="displayModal" tabindex="-1" role="dialog" aria-labelledby="displayModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="displayModalLabel"><?php echo e(__('File Display')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <img id="displayImage" src="" />
                    <p id="displayFilename"></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                    <button type="button" id="downloadFile" class="btn btn-primary"><?php echo e(__('Download')); ?></button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="settings" tabindex="-1" role="dialog" aria-labelledby="settingsLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="settingsLabel"><?php echo e(__('Settings')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group row">
                        <div class="col-lg-3 col-md-4 text-left">
                            <label for="videoQualitySelect"><?php echo e(__('Video quality')); ?> </label>
                        </div>
                        <div class="col-lg-9 col-md-8">
                            <select id="videoQualitySelect" class="form-control">
                                <option id="QVGA" data-width="320" data-height="240"><?php echo e(__('QVGA')); ?></option>
                                <option id="VGA" data-width="640" data-height="480" selected><?php echo e(__('VGA')); ?>

                                </option>
                                <option id="HD" data-width="1280" data-height="720"><?php echo e(__('HD')); ?></option>
                                <option id="FHD" data-width="1920" data-height="1080"><?php echo e(__('FHD')); ?></option>
                                <option id="4K" data-width="3840" data-height="2160"><?php echo e(__('4K')); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-lg-3 col-md-4 text-left">
                            <label for="audioSource"><?php echo e(__('Audio input source')); ?> </label>
                        </div>
                        <div class="col-lg-9 col-md-8">
                            <select id="audioSource" class="form-control"></select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-lg-3 col-md-4 text-left">
                            <label for="videoSource"><?php echo e(__('Video source')); ?> </label>
                        </div>
                        <div class="col-lg-9 col-md-8">
                            <select id="videoSource" class="form-control"></select>
                        </div>
                    </div>

                    <div class="form-group row">
                        <div class="col-lg-3 col-md-4 text-left">
                            <label for="recordingPreference"><?php echo e(__('Recording preference')); ?> </label>
                        </div>
                        <div class="col-lg-9 col-md-8">
                            <select id="recordingPreference" class="form-control">
                                <option value="with"><?php echo e(__('With whiteboard')); ?></option>
                                <option value="without"><?php echo e(__('Without whiteboard')); ?></option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group row">
                        <div class="col-lg-3 col-md-4 text-left">
                            <label for="videoObjectFit"><?php echo e(__('Video object-fit')); ?> </label>
                        </div>
                        <div class="col-lg-9 col-md-8">
                            <select id="videoObjectFit" class="form-control">
                                <option value="contain"><?php echo e(__('Contain')); ?></option>
                                <option value="cover"><?php echo e(__('Cover')); ?></option>
                                <option value="fill"><?php echo e(__('Fill')); ?></option>
                                <option value="none"><?php echo e(__('None')); ?></option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="shortcutInfo" tabindex="-1" role="dialog" aria-labelledby="shortcutInfoLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="shortcutInfoLabel"><?php echo e(__('Settings')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <table class="table table-borderless">
                        <thead>
                            <tr>
                                <th scope="col"><?php echo e(__('Shortcut Key')); ?></th>
                                <th scope="col"><?php echo e(__('Action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <th scope="row">C</th>
                                <td><?php echo e(__('Chat')); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">F</th>
                                <td><?php echo e(__('Attach File')); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">A</th>
                                <td><?php echo e(__('Mute/Unmute Audio')); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">L</th>
                                <td><?php echo e(__('Leave Meeting')); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">V</th>
                                <td><?php echo e(__('On/Off Video')); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">S</th>
                                <td><?php echo e(__('Screen Share')); ?></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="participantList" tabindex="-1" role="dialog" aria-labelledby="participantListLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="participantListLabel"><?php echo e(__('Participants')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <table class="table table-borderless">
                        <thead>
                            <tr>
                                <th scope="col"><?php echo e(__('#')); ?></th>
                                <th scope="col"><?php echo e(__('Name')); ?></th>
                            </tr>
                        </thead>
                        <tbody id="participantListBody">
                            <tr>
                                <th scope="row"></th>
                                <td>
                                    <?php echo e(__('You')); ?>

                                    <i class='fas fa-crown moderator-icon' title='<?php echo e(__('Moderator')); ?>' <?php if(!$meeting->isModerator): ?> style="display: none" <?php endif; ?>></i>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary add"><?php echo e(__('Invite')); ?></button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                </div>
            </div>
        </div>
    </div>

    <div id="overlay">
        <div class="overlay-wrapper">
            <p id="overlayText"></p>
            <img src="/images/allow.png" alt="<?php echo e(__('Allow Camera')); ?>" />
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        const userInfo = {
            username: htmlEscape(username.value),
            meetingId: "<?php echo e($meeting->meeting_id); ?>",
            avatar: "<?php echo e(getAuthUserInfo('avatar')); ?>"
        };

        const passwordRequired = "<?php echo e(!!$meeting->password); ?>";
        const moderator = "<?php echo e($meeting->isModerator); ?>";
        const meetingTitle = "<?php echo e($meeting->title); ?>";
        const timeLimit = "<?php echo e($meeting->timeLimit == -1 ? 9999 : $meeting->timeLimit); ?>";
        const userLimit = "<?php echo e($meeting->userLimit == -1 ? 9999 : $meeting->userLimit); ?>";
        const features = JSON.parse("<?php echo e(json_encode($meeting->features)); ?>".replace(/&quot;/g, '"'));
        Object.freeze(features);
    </script>
    <script src="<?php echo e(asset('js/socket.io.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/easytimer.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/siofu.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/MultiStreamsMixer.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/opentok-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/canvas-designer-widget.js')); ?>"></script>
    <script src="<?php echo e(asset('js/meeting2.js')); ?>"></script>
    <script src="<?php echo e(asset('js/emoji.js')); ?>"></script>
    <script src="<?php echo e(asset('js/meeting.js?version=') . getVersion()); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\webinar\resources\views/meeting.blade.php ENDPATH**/ ?>