<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e(getSelectedLanguage()->direction); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('title'); ?></title>

    <!-- Styles -->
    <style type="text/css">
        :root {
            --secondary-color: #536d79;
            --primary-color: <?php echo e(getSetting('PRIMARY_COLOR')); ?>;
        }
    </style>
    <link href="<?php echo e(asset('css/app.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/fa.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/toastr.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/style.css?version=') . getVersion()); ?>" rel="stylesheet">
    <link rel="icon" type="image/png" href="<?php echo e(asset('storage/images/FAVICON.png')); ?>">

    <?php if(getSetting('PWA') == 'enabled'): ?>
        <link rel="manifest" href="/manifest.json">
    <?php endif; ?>

    <?php echo $__env->yieldContent('style'); ?>

    <style>
        <?php echo getSetting('CUSTOM_CSS'); ?>

    </style>
    <?php echo getSetting('CUSTOM_JS'); ?>

</head>

<body>
    <div id="app">
        <nav class="navbar navbar-expand-md shadow-sm">
            <a class="navbar-brand" href="<?php echo e(url('/')); ?>">
                <img src="<?php echo e(asset('storage/images/PRIMARY_LOGO.png')); ?>" alt="<?php echo e(getSetting('APPLICATION_NAME')); ?>"
                    class="logo-inner">
            </a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent"
                aria-controls="navbarSupportedContent" aria-expanded="false"
                aria-label="<?php echo e(__('Toggle navigation')); ?>">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <!-- Left Side Of Navbar -->
                <ul class="navbar-nav mr-auto">

                </ul>

                <!-- Right Side Of Navbar -->
                <ul class="navbar-nav ml-auto">
                    <?php if(getLanguages()->count() > 1): ?>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button"
                                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fa fa-globe"></i> <?php echo e(getSelectedLanguage()->name); ?>

                            </a>
                            <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                                <?php $__currentLoopData = getLanguages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a class="dropdown-item <?php if(getSelectedLanguage()->name == $language->name): ?> active <?php endif; ?>"
                                        href="<?php echo e(route('language', ['locale' => $language->code])); ?>"><?php echo e($language->name); ?></a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </li>
                    <?php endif; ?>

                    <!-- Authentication Links -->
                    <?php if(auth()->guard()->guest()): ?>
                        <?php if(Route::has('pricing') && count(paymentGateways()) != 0 && getSetting('PAYMENT_MODE') == 'enabled'): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('pricing')); ?>"><?php echo e(__('Pricing')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(Route::has('login') && getSetting('AUTH_MODE') == 'enabled'): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('login')); ?>"><?php echo e(__('Login')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(Route::has('register') && getSetting('AUTH_MODE') == 'enabled'): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('register')); ?>"><?php echo e(__('Register')); ?></a>
                            </li>
                        <?php endif; ?>
                    <?php else: ?>
                        <?php if(getAuthUserInfo('role') == 'admin'): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('admin')); ?>"><?php echo e(__('Admin')); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if(getSetting('AUTH_MODE') == 'enabled'): ?>
                            <?php if(Route::has('pricing') && count(paymentGateways()) != 0 && getSetting('PAYMENT_MODE') == 'enabled'): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(route('pricing')); ?>"><?php echo e(__('Pricing')); ?></a>
                                </li>
                            <?php endif; ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                            </li>
                        <?php endif; ?>

                        <li class="nav-item dropdown">
                            <a id="profileDropdown" class="nav-link dropdown-toggle set-profile" href="#"
                                role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                                <?php echo e(getAuthUserInfo('username')); ?>

                                <?php if(getAuthUserInfo('avatar')): ?>
                                    <img src="<?php echo e(asset('storage/avatars/' . getAuthUserInfo('avatar'))); ?>"
                                        class="user-avatar">
                                <?php else: ?>
                                    <span class="user-avatar"><?php echo e(ucfirst(getAuthUserInfo('username')[0])); ?></span>
                                <?php endif; ?>
                            </a>

                            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="profileDropdown">
                                <a class="dropdown-item" href="<?php echo e(route('profile.profile')); ?>">
                                    <?php echo e(__('Profile')); ?>

                                </a>
                                <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                                    onclick="event.preventDefault();
                                                                             document.getElementById('logout-form').submit();">
                                    <?php echo e(__('Logout')); ?>

                                </a>

                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                    <?php echo csrf_field(); ?>
                                </form>
                            </div>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </nav>

        <main class="pt-4 mb-5 mb-md-0">
            <?php echo $__env->yieldContent('content'); ?>
        </main>

        <footer class="app-footer">
            <div class="container-fluid">
                <div class="row d-flex align-items-top">
                    <div class="col-12 col-md-9 text-md-left text-center pad-res">
                        <ul class="footer-links">
                            <?php $__currentLoopData = getPages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <a href="<?php echo e('/pages/' . $page->slug); ?>"><?php echo e(__($page->title)); ?></a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                        <p><?php echo e(__('Copyright')); ?> &copy; <?php echo e(date('Y')); ?>

                            <?php echo e(getSetting('APPLICATION_NAME')); ?>. <?php echo e(__('All rights reserved')); ?></p>
                    </div>
                    <div class="col-12 col-md-3 text-md-right text-center pad-res">
                        <div class="social-data">
                            <p><strong><?php echo e(__('Share with your friends')); ?></strong></p>
                            <ul class="social-links">
                                <li>
                                    <a href="" target="_blank" id="fbShare" rel="noreferrer">
                                        <i class="fab fa-facebook-f"></i>
                                    </a>
                                </li>
                                <li>
                                    <a href="" target="_blank" id="twitterShare" rel="noreferrer">
                                        <i class="fab fa-twitter"></i>
                                    </a>
                                </li>
                                <li>
                                    <a href="" target="_blank" id="waShare" rel="noreferrer">
                                        <i class="fab fa-whatsapp"></i>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </footer>
        <div class="cookie">
            <p><i class="fa fa-cookie-bite"></i>
                <?php echo e(__('This website uses cookies to ensure you get the best experience on our website')); ?>

                <a href="/pages/privacy-policy"> <?php echo e(__('Learn more')); ?></a>
            </p>
            <button class="btn btn-theme confirm-cookie"><?php echo e(__('Got it')); ?></button>
        </div>

        <?php if(isDemoMode()): ?>
            <div id="buy-now">
                <a id="buy-now-link" href="https://codecanyon.net/cart/configure_before_adding/37367339"
                    target="_blank"><span>$</span><?php echo e(config('app.script_price')); ?></a>
                <button class="buy-now-button" onclick="document.getElementById('buy-now-link').click();">
                    <?php echo e(__('Buy Now')); ?>

                </button>
            </div>
        <?php endif; ?>
    </div>

    <?php if(getSetting('PWA') == 'enabled'): ?>
        <?php echo $__env->make('include.pwa-installation-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <script type="text/javascript">
            if ('serviceWorker' in navigator) {
                navigator.serviceWorker.register('/serviceworker.js', {
                    scope: '.'
                }).then(function(registration) {}, function(err) {});
            }
        </script>
    <?php endif; ?>

    <script>
        const cookieConsent = "<?php echo e(getSetting('COOKIE_CONSENT')); ?>";
        const googleAnalyticsTrackingId = "<?php echo e(getSetting('GOOGLE_ANALYTICS_ID')); ?>";
        const socialInvitation = "<?php echo e(getSetting('SOCIAL_INVITATION')); ?>";
        const pwa = "<?php echo e(getSetting('PWA')); ?>";

        const languages = {
            error_occurred: "<?php echo e(__('An error occurred, please try again')); ?>",
            data_updated: "<?php echo e(__('Data updated successfully')); ?>",
            no_meeting: "<?php echo e(__('The meeting does not exist')); ?>",
            meeting_created: "<?php echo e(__('The meeting has been created')); ?>",
            confirmation: "<?php echo e(__('Are you sure')); ?>",
            meeting_deleted: "<?php echo e(__('The meeting has been deleted')); ?>",
            link_copied: "<?php echo e(__('Meeting link has been copied to the clipboard')); ?>",
            meeting_updated: "<?php echo e(__('The meeting has been updated')); ?>",
            sending_invite: "<?php echo e(__('Sending the invitation')); ?>",
            invite_sent: "<?php echo e(__('Invitation has been sent')); ?>",
            inviteMessage: "<?php echo e(__('Hey there! Join me for a meeting at this link')); ?>",
            no_session: "<?php echo e(__('Could not get the session details')); ?>",
            kicked: "<?php echo e(__('You have been kicked out of the meeting')); ?>",
            uploading: "<?php echo e(__('Uploading the file')); ?>",
            meeting_ended: "<?php echo e(__('Meeting ended')); ?>",
            cant_connect: "<?php echo e(__('Could not connect to the server, please try again later')); ?>",
            invalid_password: "<?php echo e(__('The password is invalid')); ?>",
            no_device: "<?php echo e(__('Could not get the devices, please check the permissions and try again. Error')); ?>",
            approve: "<?php echo e(__('Approve')); ?>",
            decline: "<?php echo e(__('Decline')); ?>",
            request_join_meeting: "<?php echo e(__('Request to join the meeting')); ?>",
            request_declined: "<?php echo e(__('Your request has been declined by the moderator')); ?>",
            double_click: "<?php echo e(__('Double click on the video to make it fullscreen')); ?>",
            single_click: "<?php echo e(__('Single click on the video to turn picture-in-picture mode on')); ?>",
            error_message: "<?php echo e(__('An error occurred')); ?>",
            kick_user: "<?php echo e(__('Kick this user')); ?>",
            participant_joined: "<?php echo e(__('A participant has joined the meeting')); ?>",
            confirmation_kick: "<?php echo e(__('Are you sure you want to kick this user')); ?>",
            participant_left: "<?php echo e(__('A participant has left the meeting')); ?>",
            camera_on: "<?php echo e(__('Camera has been turned on')); ?>",
            camera_off: "<?php echo e(__('Camera has been turned off')); ?>",
            mic_unmute: "<?php echo e(__('Mic has been unmute')); ?>",
            mic_mute: "<?php echo e(__('Mic has been muted')); ?>",
            no_video: "<?php echo e(__('The video is not playing or has no video track')); ?>",
            no_pip: "<?php echo e(__('Picture-in-picture mode is not supported in this browser')); ?>",
            link_copied: "<?php echo e(__('The meeting invitation link has been copied to the clipboard')); ?>",
            cant_share_screen: "<?php echo e(__('Could not share the screen, please check the permissions and try again')); ?>",
            max_file_size: "<?php echo e(__('Maximum file size allowed (MB)')); ?>",
            view_file: "<?php echo e(__('View File')); ?>",
            hand_raised: "<?php echo e(__('Hand raised')); ?>",
            hand_raised_self: "<?php echo e(__('You raised hand')); ?>",
            your_screen: "<?php echo e(__('Your screen')); ?>",
            not_started: "<?php echo e(__('The meeting has not been started yet')); ?>",
            meeting_full: "<?php echo e(__('The meeting is full')); ?>",
            please_wait: "<?php echo e(__('Please wait while the moderator check your request')); ?>",
            request_record_meeting: "<?php echo e(__('Request to record the meeting')); ?>",
            request_screenshare: "<?php echo e(__('Request to start screen sharing')); ?>",
            record_request_declined: "<?php echo e(__('Your recording request was not approved')); ?>",
            screenshare_request_declined: "<?php echo e(__('Your screen share request was not approved')); ?>",
            feature_not_supported: "<?php echo e(__('This feature is not yet supported in your browser')); ?>",
            feature_not_available: "<?php echo e(__('This feature is not available in the current meeting plan')); ?>",
            password: "<?php echo e(__('Password: ')); ?>",
            calendar_check: "<?php echo e(__('Please set a date and time')); ?>",
            recording_started: "<?php echo e(__('The recording has been started')); ?>",
            token_copied: "<?php echo e(__('API Token has been copied to the clipboard')); ?>",
            screen: "<?php echo e(__('Screen-')); ?>",
            checking_mic_permission: "<?php echo e(__('Checking microphone permission')); ?>",
            checking_cam_permission: "<?php echo e(__('Checking camera permission')); ?>",
            click_allow: "<?php echo e(__('Click \"Allow\"')); ?>",
            personal_link_copied: "<?php echo e(__('Your personal meeting link has been copied to the clipboard')); ?>",
            toggleMic: "<?php echo e(__('Mute/Unmute Mic')); ?>",
            toggleCamera: "<?php echo e(__('On/Off Camera')); ?>",
            you_muted: "<?php echo e(__('You muted all the participants')); ?>",
            you_unmuted: "<?php echo e(__('You unmuted all the participants')); ?>",
            mic_muted_moderator: "<?php echo e(__('Mic has been muted by the moderator')); ?>",
            mic_unmuted_moderator: "<?php echo e(__('Mic has been unmuted by the moderator')); ?>",
            camera_off_moderator: "<?php echo e(__('Camera has been turned off by the moderator')); ?>",
            camera_on_moderator: "<?php echo e(__('Camera has been turned on by the moderator')); ?>",
            moderator: "<?php echo e(__('Moderator')); ?>",
            moderator_updated: "<?php echo e(__('The moderator has been updated. New moderator: ')); ?>",
            make_moderator: "<?php echo e(__('Make Moderator')); ?>",
            you_moderator: "<?php echo e(__('You are now the moderator')); ?>",
            moderator_confirm: "<?php echo e(__('Are you sure you want to switch the moderator right? This action can not be undone')); ?>"
        }
    </script>

    <!-- Scripts -->
    <script src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/toastr.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/main.js?version=') . getVersion()); ?>"></script>
    <?php echo $__env->yieldContent('script'); ?>
</body>

</html>
<?php /**PATH /home/originsuiteai/webinar_main/resources/views/layouts/app.blade.php ENDPATH**/ ?>