

<?php $__env->startSection('profile-content'); ?>
    <link href="<?php echo e(asset('css/cropper.min.css')); ?>" rel="stylesheet">
    <script src="<?php echo e(asset('js/cropper.min.js')); ?>"></script>

    <?php echo $__env->make('include.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <form action="<?php echo e(route('profile.profile.update')); ?>" method="post" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group">
                            <div class="user-profile-upload">
                                <input type="hidden" name="userid" id="userid" value="<?php echo e(getAuthUserInfo('id')); ?>" />
                                <div class="user-initial" for="avatar">
                                    <?php if(getAuthUserInfo('avatar') && file_exists(public_path('storage/avatars/' . getAuthUserInfo('avatar')))): ?>
                                        <button class="btn btn-danger" type="button" id="removeAvatar"><i
                                                class="fa fa-times"></i></button>
                                    <?php endif; ?>
                                    <?php if(getAuthUserInfo('avatar') && file_exists(public_path('storage/avatars/' . getAuthUserInfo('avatar')))): ?>
                                        <?php $avatar = getAuthUserInfo('avatar'); ?>
                                        <img id="imagePreview" src="<?php echo e(asset('storage/avatars/' . $avatar)); ?>"
                                            alt="User profile picture">
                                    <?php else: ?>
                                        <p id="initial"><?php echo e(ucfirst(getAuthUserInfo('username')[0])); ?>

                                        </p>
                                        <img class="" style="display:none;" id="imagePreview">
                                    <?php endif; ?>
                                </div>

                                <input id="avatarchange" type="file"
                                    class="form-control<?php echo e($errors->has('avatar') ? ' is-invalid' : ''); ?>" name="avatar"
                                    value="<?php echo e(old('avatar')); ?>" autocomplete="avatar" accept=".png, .jpg">
                            </div>

                            <?php if($errors->has('avatar')): ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($errors->first('avatar')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-6">
                        <div class="form-group">
                            <label for="i-name"><?php echo e(__('Username')); ?></label>
                            <input type="text" name="username" id="i-name"
                                class="form-control<?php echo e($errors->has('username') ? ' is-invalid' : ''); ?>"
                                value="<?php echo e(old('username') ?? $user->username); ?>" placeholder="<?php echo e(__('Username')); ?>">
                            <?php if($errors->has('username')): ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($errors->first('username')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-6">
                        <div class="form-group">
                            <label for="i-email"><?php echo e(__('Email')); ?></label>
                            <input type="text" name="email" id="i-email"
                                class="form-control<?php echo e($errors->has('email') ? ' is-invalid' : ''); ?>"
                                value="<?php echo e(old('email') ?? $user->email); ?>" placeholder="<?php echo e(__('Email')); ?>">
                            <?php if($errors->has('email')): ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($errors->first('email')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col">
                        <button type="submit" name="submit" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <div class="modal fade" id="previewModal" tabindex="-1" role="dialog" aria-labelledby="previewModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered mw-650px">
            <div class="modal-content">
                <!--begin::Modal header-->
                <div class="modal-header" id="create-modal-add-services_header">
                    <!--begin::Modal title-->
                    <h2 class="fw-bold js-edit-title"><?php echo e(__('Crop')); ?></h2>
                    <!--end::Modal title-->
                    <!--begin::Close-->
                    <div class="btn btn-icon btn-sm btn-active-icon-primary" data-dismiss="modal">
                        <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                        <span class="svg-icon svg-icon-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1"
                                    transform="rotate(-45 6 17.3137)" fill="currentColor" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1"
                                    transform="rotate(45 7.41422 6)" fill="currentColor" />
                            </svg>
                        </span>
                        <!--end::Svg Icon-->
                    </div>
                    <!--end::Close-->
                </div>
                <!--end::Modal header-->
                <div class="modal-body py-10 px-lg-17 text-center">
                    <div class="crop-img-section">
                        <img id="previewImage" />
                    </div>
                </div>
                <div class="modal-footer flex-center">
                    <button type="button" class="btn btn-light me-3" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                    <button id="crop_button" type="button" class="btn btn-primary"><?php echo e(__('Crop & Save')); ?></button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('profile.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/originsuiteai/webinar.originsuiteai.com/resources/views/profile/profile.blade.php ENDPATH**/ ?>